package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithBannerHrefParams;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithBannerHrefParamsValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithBannerHrefParamsUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithBannerHrefParams> {

    public CampaignWithBannerHrefParamsUpdateValidationTypeSupport() {
    }

    @Override
    public Class<CampaignWithBannerHrefParams> getTypeClass() {
        return CampaignWithBannerHrefParams.class;
    }

    @Override
    public ValidationResult<List<CampaignWithBannerHrefParams>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithBannerHrefParams>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(new CampaignWithBannerHrefParamsValidator())
                .getResult();
    }
}
