package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithBrandLiftHiddenForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.forEachModelChangesAddDefectIfFieldChanged;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithBrandLiftHiddenForbiddenUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithBrandLiftHiddenForbidden> {

    @Override
    public Class<CampaignWithBrandLiftHiddenForbidden> getTypeClass() {
        return CampaignWithBrandLiftHiddenForbidden.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithBrandLiftHiddenForbidden>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithBrandLiftHiddenForbidden>>, Defect> vr
    ) {
        forEachModelChangesAddDefectIfFieldChanged(
                vr, CampaignWithBrandLiftHiddenForbidden.IS_BRAND_LIFT_HIDDEN);
        return vr;
    }
}
