package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithBrandSafety;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithBrandSafetyValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithBrandSafetyUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithBrandSafety> {

    private final FeatureService featureService;

    public CampaignWithBrandSafetyUpdateValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithBrandSafety> getTypeClass() {
        return CampaignWithBrandSafety.class;
    }

    @Override
    public ValidationResult<List<CampaignWithBrandSafety>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithBrandSafety>, Defect> vr) {
        Set<String> clientFeatures = featureService.getEnabledForClientId(container.getClientId());

        return new ListValidationBuilder<>(vr)
                .checkEachBy(new CampaignWithBrandSafetyValidator(clientFeatures))
                .getResult();
    }
}
