package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithCampaignsPromotions;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithCampaignsPromotionsValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithCampaignsPromotionsUpdateValidationTypeSupport extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithCampaignsPromotions> {

    @Override
    public Class<CampaignWithCampaignsPromotions> getTypeClass() {
        return CampaignWithCampaignsPromotions.class;
    }

    @Override
    public ValidationResult<List<CampaignWithCampaignsPromotions>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithCampaignsPromotions>, Defect> vr) {
        var vb = new ListValidationBuilder<>(vr)
                .checkEachBy(campaign ->
                        new CampaignWithCampaignsPromotionsValidator().apply(campaign));
        return vb.getResult();
    }
}
