package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithCustomCheckPositionEvent;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithCustomCheckPositionEventValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithCheckPositionEventUpdateValidationTypeSupport extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithCustomCheckPositionEvent> {

    @Override
    public Class<CampaignWithCustomCheckPositionEvent> getTypeClass() {
        return CampaignWithCustomCheckPositionEvent.class;
    }

    @Override
    public ValidationResult<List<CampaignWithCustomCheckPositionEvent>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithCustomCheckPositionEvent>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(campaign -> new CampaignWithCustomCheckPositionEventValidator().apply(campaign))
                .getResult();
    }
}
