package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithContactInfo;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithContactInfoValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.vcard.service.validation.MetroIdValidator;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithContactInfoUpdateValidationTypeSupport extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithContactInfo> {
    private final MetroIdValidator metroIdValidator;

    @Autowired
    public CampaignWithContactInfoUpdateValidationTypeSupport(MetroIdValidator metroIdValidator) {
        this.metroIdValidator = metroIdValidator;
    }

    @Override
    public Class<CampaignWithContactInfo> getTypeClass() {
        return CampaignWithContactInfo.class;
    }

    @Override
    public ValidationResult<List<CampaignWithContactInfo>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithContactInfo>, Defect> vr,
            Map<Integer, AppliedChanges<CampaignWithContactInfo>> appliedChangesForValidModelChanges) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy((index, campaign) -> CampaignWithContactInfoValidator
                        .build(metroIdValidator, appliedChangesForValidModelChanges.get(index))
                        .apply(campaign))
                .getResult();
    }
}
