package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.Campaign;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithCustomDayBudget;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithCustomDayBudgetValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.client.service.ClientService;
import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.utils.FunctionalUtils.listToMap;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithCustomDayBudgetUpdateValidationTypeSupport extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithCustomDayBudget> {
    private final ClientService clientService;
    private final CampaignRepository campaignRepository;

    @Autowired
    public CampaignWithCustomDayBudgetUpdateValidationTypeSupport(ClientService clientService,
                                                                  CampaignRepository campaignRepository) {
        this.clientService = clientService;
        this.campaignRepository = campaignRepository;
    }

    @Override
    public Class<CampaignWithCustomDayBudget> getTypeClass() {
        return CampaignWithCustomDayBudget.class;
    }

    @Override
    public ValidationResult<List<CampaignWithCustomDayBudget>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithCustomDayBudget>, Defect> vr,
            Map<Integer, AppliedChanges<CampaignWithCustomDayBudget>> appliedChangesForValidModelChanges) {
        Currency currency = Objects.requireNonNull(clientService.getClient(container.getClientId())).getWorkCurrency().getCurrency();

        Map<CampaignWithCustomDayBudget, Long> walletIdsByCampaign = StreamEx.of(vr.getValue())
                .filter(campaignWithDayBudget -> campaignWithDayBudget.getWalletId() > 0)
                .toMap(Function.identity(), CampaignWithCustomDayBudget::getWalletId);

        Map<Long, Campaign> walletByIds;

        if (walletIdsByCampaign.isEmpty()) {
            walletByIds = Collections.emptyMap();
        } else {
            List<Long> walletIds = StreamEx.of(walletIdsByCampaign.values())
                    .distinct()
                    .toList();

            walletByIds = listToMap(campaignRepository.getCampaigns(container.getShard(), walletIds), Campaign::getId,
                    Function.identity());
        }

        return new ListValidationBuilder<>(vr)
                .checkEachBy((index, campaign) -> new CampaignWithCustomDayBudgetValidator(currency,
                        walletByIds.get(campaign.getWalletId()), appliedChangesForValidModelChanges.get(index))
                        .apply(campaign))
                .getResult();
    }

}
