package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithCustomStrategyAndCustomDayBudget;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithCustomStrategyAndCustomDayBudgetValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelChangesValidationBuilder;

import static ru.yandex.direct.core.entity.campaign.service.CampaignStrategyUtils.strategySupportsDayBudget;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefects.dailyBudgetIsOnlyUsefulForManualStrategies;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithCustomStrategyAndCustomDayBudgetUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithCustomStrategyAndCustomDayBudget> {
    @Override
    public Class<CampaignWithCustomStrategyAndCustomDayBudget> getTypeClass() {
        return CampaignWithCustomStrategyAndCustomDayBudget.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithCustomStrategyAndCustomDayBudget>>, Defect>
    validateBeforeApply(CampaignValidationContainer container,
                        ValidationResult<List<ModelChanges<CampaignWithCustomStrategyAndCustomDayBudget>>, Defect> vr,
                        Map<Long, CampaignWithCustomStrategyAndCustomDayBudget> unmodifiedModels) {
        Validator<ModelChanges<CampaignWithCustomStrategyAndCustomDayBudget>, Defect> validator = changes -> {
            ModelChangesValidationBuilder<CampaignWithCustomStrategyAndCustomDayBudget> vb =
                    ModelChangesValidationBuilder.of(changes);

            var unmodifiedModel = unmodifiedModels.get(changes.getId());
            if (unmodifiedModel == null) {
                return vb.getResult();
            }

            vb.item(CampaignWithCustomStrategyAndCustomDayBudget.STRATEGY)
                    .weakCheck(
                            Constraint.fromPredicate(
                                    val -> strategySupportsDayBudget(val)
                                            // если пользователь передал dayBudget, то не надо показывать warning,
                                            // т.к. в таком случае правильнее показать ошибку валидации
                                            || changes.isPropChanged(
                                                    CampaignWithCustomStrategyAndCustomDayBudget.DAY_BUDGET)
                                            || unmodifiedModel.getDayBudget().compareTo(BigDecimal.ZERO) == 0,
                                    dailyBudgetIsOnlyUsefulForManualStrategies())
                    );

            return vb.getResult();
        };

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator, When.isValid())
                .getResult();
    }

    @Override
    public ValidationResult<List<CampaignWithCustomStrategyAndCustomDayBudget>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithCustomStrategyAndCustomDayBudget>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(campaign -> new CampaignWithCustomStrategyAndCustomDayBudgetValidator().apply(campaign))
                .getResult();
    }
}
