package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithDisabledVideoPlacements;
import ru.yandex.direct.core.entity.campaign.service.validation.DisableDomainValidationService;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithDisabledVideoPlacementsValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.client.service.ClientLimitsService;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithDisabledVideoPlacementsUpdateValidationTypeSupport extends
        AbstractCampaignUpdateValidationTypeSupport<CampaignWithDisabledVideoPlacements> {

    private final ClientLimitsService clientLimitsService;
    private final DisableDomainValidationService disableDomainValidationService;

    @Autowired
    public CampaignWithDisabledVideoPlacementsUpdateValidationTypeSupport(ClientLimitsService clientLimitsService,
                                                                          DisableDomainValidationService disableDomainValidationService) {
        this.clientLimitsService = clientLimitsService;
        this.disableDomainValidationService = disableDomainValidationService;
    }

    @Override
    public Class<CampaignWithDisabledVideoPlacements> getTypeClass() {
        return CampaignWithDisabledVideoPlacements.class;
    }

    @Override
    public ValidationResult<List<CampaignWithDisabledVideoPlacements>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithDisabledVideoPlacements>, Defect> vr) {
        var vb = new ListValidationBuilder<>(vr);

        Integer videoBlacklistSizeLimit =
                clientLimitsService.getClientLimits(container.getClientId())
                        .getVideoBlacklistSizeLimitOrDefault().intValue();

        vb.checkEachBy(campaign -> new CampaignWithDisabledVideoPlacementsValidator(videoBlacklistSizeLimit,
                container.getClientId(), disableDomainValidationService).apply(campaign));

        return vb.getResult();
    }

}
