package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithEnableCompanyInfoForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.forEachModelChangesAddDefectIfFieldChanged;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithEnableCompanyInfoForbiddenUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithEnableCompanyInfoForbidden> {

    @Autowired
    public CampaignWithEnableCompanyInfoForbiddenUpdateValidationTypeSupport() {
    }

    @Override
    public Class<CampaignWithEnableCompanyInfoForbidden> getTypeClass() {
        return CampaignWithEnableCompanyInfoForbidden.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithEnableCompanyInfoForbidden>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithEnableCompanyInfoForbidden>>, Defect> vr) {
        forEachModelChangesAddDefectIfFieldChanged(vr, CampaignWithEnableCompanyInfoForbidden.ENABLE_COMPANY_INFO);
        return vr;
    }

}
