package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithEnableCompanyInfo;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithEnableCompanyInfoValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithEnableCompanyInfoUpdateValidationTypeSupport extends
        AbstractCampaignUpdateValidationTypeSupport<CampaignWithEnableCompanyInfo> {

    @Override
    public Class<CampaignWithEnableCompanyInfo> getTypeClass() {
        return CampaignWithEnableCompanyInfo.class;
    }

    @Override
    public ValidationResult<List<CampaignWithEnableCompanyInfo>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithEnableCompanyInfo>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(new CampaignWithEnableCompanyInfoValidator())
                .getResult();
    }

}
