package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithEnableCpcHoldForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.forEachModelChangesAddDefectIfFieldChanged;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithEnableCpcHoldForbiddenUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithEnableCpcHoldForbidden> {

    @Autowired
    public CampaignWithEnableCpcHoldForbiddenUpdateValidationTypeSupport() {
    }

    @Override
    public Class<CampaignWithEnableCpcHoldForbidden> getTypeClass() {
        return CampaignWithEnableCpcHoldForbidden.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithEnableCpcHoldForbidden>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithEnableCpcHoldForbidden>>, Defect> vr) {
        forEachModelChangesAddDefectIfFieldChanged(vr, CampaignWithEnableCpcHoldForbidden.ENABLE_CPC_HOLD);
        return vr;
    }

}
