package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithEshowsSettingsAndStrategy;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithEshowsSettingsAndStrategyValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithEshowsSettingsAndStrategyUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithEshowsSettingsAndStrategy> {

    @Override
    public Class<CampaignWithEshowsSettingsAndStrategy> getTypeClass() {
        return CampaignWithEshowsSettingsAndStrategy.class;
    }

    @Override
    public ValidationResult<List<CampaignWithEshowsSettingsAndStrategy>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithEshowsSettingsAndStrategy>, Defect> vr,
            Map<Integer, AppliedChanges<CampaignWithEshowsSettingsAndStrategy>> appliedChanges
    ) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy((index, campaign) -> CampaignWithEshowsSettingsAndStrategyValidator
                        .build(appliedChanges.get(index)).apply(campaign))
                .getResult();
    }
}
