package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithExcludePausedCompetingAds;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithExcludePausedCompetingAdsValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithExcludePausedCompetingAdsUpdateValidationTypeSupport extends
        AbstractCampaignUpdateValidationTypeSupport<CampaignWithExcludePausedCompetingAds> {


    @Override
    public Class<CampaignWithExcludePausedCompetingAds> getTypeClass() {
        return CampaignWithExcludePausedCompetingAds.class;
    }

    @Override
    public ValidationResult<List<CampaignWithExcludePausedCompetingAds>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithExcludePausedCompetingAds>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(new CampaignWithExcludePausedCompetingAdsValidator())
                .getResult();
    }

}
