package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAdvancedGeoTargeting;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithExtendedGeoTargetingForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.forEachModelChangesAddDefectIfFieldChanged;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithExtendedGeoTargetingForbiddenUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithExtendedGeoTargetingForbidden> {

    @Autowired
    public CampaignWithExtendedGeoTargetingForbiddenUpdateValidationTypeSupport() {
    }

    @Override
    public Class<CampaignWithExtendedGeoTargetingForbidden> getTypeClass() {
        return CampaignWithExtendedGeoTargetingForbidden.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithExtendedGeoTargetingForbidden>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithExtendedGeoTargetingForbidden>>, Defect> vr) {
        forEachModelChangesAddDefectIfFieldChanged(vr, CampaignWithAdvancedGeoTargeting.HAS_EXTENDED_GEO_TARGETING);
        return vr;
    }

}
