package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithFixedTimeTargeting;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.forEachModelChangesAddDefectIfFieldChanged;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithFixedTimeTargetingUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithFixedTimeTargeting> {

    @Autowired
    public CampaignWithFixedTimeTargetingUpdateValidationTypeSupport() {
    }

    @Override
    public Class<CampaignWithFixedTimeTargeting> getTypeClass() {
        return CampaignWithFixedTimeTargeting.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithFixedTimeTargeting>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithFixedTimeTargeting>>, Defect> vr) {
        forEachModelChangesAddDefectIfFieldChanged(vr, CampaignWithFixedTimeTargeting.TIME_TARGET);
        return vr;
    }

}
