package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithForbiddenCheckPositionEvent;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.forEachModelChangesAddDefectIfFieldChanged;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithForbiddenCheckPositionEventUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithForbiddenCheckPositionEvent> {
    @Override
    public Class<CampaignWithForbiddenCheckPositionEvent> getTypeClass() {
        return CampaignWithForbiddenCheckPositionEvent.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithForbiddenCheckPositionEvent>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithForbiddenCheckPositionEvent>>, Defect> vr) {

        if (!container.getOptions().isForceEnableCheckPositionEvent()) {
            forEachModelChangesAddDefectIfFieldChanged(vr,
                    CampaignWithForbiddenCheckPositionEvent.ENABLE_CHECK_POSITION_EVENT);
        }
        if (!container.getOptions().isForceCheckPositionIntervalEvent()) {
            forEachModelChangesAddDefectIfFieldChanged(vr,
                    CampaignWithForbiddenCheckPositionEvent.CHECK_POSITION_INTERVAL_EVENT);
        }
        return vr;
    }
}
