package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithForbiddenStrategy;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.forEachModelChangesAddDefectIfFieldChanged;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithForbiddenStrategyUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithForbiddenStrategy> {

    @Override
    public Class<CampaignWithForbiddenStrategy> getTypeClass() {
        return CampaignWithForbiddenStrategy.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithForbiddenStrategy>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithForbiddenStrategy>>, Defect> vr) {
        forEachModelChangesAddDefectIfFieldChanged(vr, CampaignWithForbiddenStrategy.STRATEGY);
        return vr;
    }

}
