package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithImpressionRate;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithImpressionRateValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithImpressionRateUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithImpressionRate> {

    @Autowired
    FeatureService featureService;

    @Override
    public Class<CampaignWithImpressionRate> getTypeClass() {
        return CampaignWithImpressionRate.class;
    }

    @SuppressWarnings("rawtypes")
    @Override
    public ValidationResult<List<CampaignWithImpressionRate>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithImpressionRate>, Defect> vr) {
        boolean  isCpmShowsFrequency50Per30On = featureService.isEnabledForClientId(container.getClientId(), FeatureName.CPM_SHOWS_FREQUENCY_50_PER_30);

        return new ListValidationBuilder<>(vr)
                .checkEachBy(new CampaignWithImpressionRateValidator(isCpmShowsFrequency50Per30On))
                .getResult();
    }

}
