package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithMobileContent;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithMobileContentValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.mobileapp.repository.MobileAppRepository;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithMobileContentUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithMobileContent> {

    private final MobileAppRepository mobileAppRepository;

    @Autowired
    public CampaignWithMobileContentUpdateValidationTypeSupport(MobileAppRepository mobileAppRepository) {
        this.mobileAppRepository = mobileAppRepository;
    }

    @Override
    public Class<CampaignWithMobileContent> getTypeClass() {
        return CampaignWithMobileContent.class;
    }

    @Override
    public ValidationResult<List<CampaignWithMobileContent>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithMobileContent>, Defect> vr) {
        var vb = new ListValidationBuilder<>(vr);

        List<Long> mobileAppIds = mapList(vr.getValue(), CampaignWithMobileContent::getMobileAppId);
        Set<Long> clientMobileAppIds =
                mobileAppRepository.getMobileAppIds(container.getShard(), container.getClientId(), mobileAppIds);

        CampaignWithMobileContentValidator validator = new CampaignWithMobileContentValidator(clientMobileAppIds,
                container.getOptions().isAllowNullDeviceTypeTargeting(),
                container.getOptions().isAllowNullNetworkTargeting(),
                container.getOptions().isAllowZeroMobileAppId());
        vb.checkEachBy(validator);
        return vb.getResult();
    }
}
