package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithNetworkSettings;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithNetworkSettingsValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.rbac.RbacService;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.AUTO_CONTEXT_LIMIT;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.MAX_CONTEXT_LIMIT;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.MIN_CONTEXT_LIMIT;
import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.addDefectOnField;
import static ru.yandex.direct.validation.defect.NumberDefects.inInterval;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithNetworkSettingsUpdateValidationTypeSupport extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithNetworkSettings> {
    private final RbacService rbacService;

    @Autowired
    public CampaignWithNetworkSettingsUpdateValidationTypeSupport(RbacService rbacService) {
        this.rbacService = rbacService;
    }

    @Override
    public Class<CampaignWithNetworkSettings> getTypeClass() {
        return CampaignWithNetworkSettings.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithNetworkSettings>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithNetworkSettings>>, Defect> vr) {

        List<ModelChanges<CampaignWithNetworkSettings>> modelChanges = vr.getValue();
        //AUTO_CONTEXT_LIMIT не может быть входным параметром, но может быть проставлен самой операцией.
        for (int i = 0; i < modelChanges.size(); i++) {
            if (AUTO_CONTEXT_LIMIT.equals(modelChanges.get(i)
                    .getPropIfChanged(CampaignWithNetworkSettings.CONTEXT_LIMIT))) {
                addDefectOnField(vr, CampaignWithNetworkSettings.CONTEXT_LIMIT, i,
                        inInterval(MIN_CONTEXT_LIMIT, MAX_CONTEXT_LIMIT));
            }
        }

        return vr;
    }

    @Override
    public ValidationResult<List<CampaignWithNetworkSettings>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithNetworkSettings>, Defect> vr) {
        CampaignWithNetworkSettingsValidator validator =
                new CampaignWithNetworkSettingsValidator(rbacService.getUidRole(container.getOperatorUid()));

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }

}
