package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithNewIosVersionForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.forEachModelChangesAddDefectIfFieldChanged;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithNewIosVersionForbiddenUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithNewIosVersionForbidden> {

    @Override
    public Class<CampaignWithNewIosVersionForbidden> getTypeClass() {
        return CampaignWithNewIosVersionForbidden.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithNewIosVersionForbidden>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithNewIosVersionForbidden>>, Defect> vr
    ) {
        forEachModelChangesAddDefectIfFieldChanged(vr, CampaignWithNewIosVersionForbidden.IS_NEW_IOS_VERSION_ENABLED);
        return vr;
    }
}
