package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithNewIosVersion;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.forEachModelChangesAddDefectIfFieldChanged;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithNewIosVersionUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithNewIosVersion> {

    private final FeatureService featureService;

    public CampaignWithNewIosVersionUpdateValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithNewIosVersion> getTypeClass() {
        return CampaignWithNewIosVersion.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithNewIosVersion>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithNewIosVersion>>, Defect> vr
    ) {
        var isShowRmpOnNewIosVersionEnabled = featureService.isEnabledForClientId(
                container.getClientId(), FeatureName.SHOW_RMP_ON_NEW_IOS_VERSION_ENABLED
        );

        if (!isShowRmpOnNewIosVersionEnabled) {
            forEachModelChangesAddDefectIfFieldChanged(vr, CampaignWithNewIosVersion.IS_NEW_IOS_VERSION_ENABLED);
        }

        return vr;
    }
}
