package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalAloneTrafaret;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithOptionalAloneTrafaretValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOptionalAloneTrafaretUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithOptionalAloneTrafaret> {

    private FeatureService featureService;

    @Autowired
    public CampaignWithOptionalAloneTrafaretUpdateValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithOptionalAloneTrafaret> getTypeClass() {
        return CampaignWithOptionalAloneTrafaret.class;
    }

    @Override
    public ValidationResult<List<CampaignWithOptionalAloneTrafaret>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithOptionalAloneTrafaret>, Defect> vr) {
        boolean isAloneTrafaretOptionEnabled = featureService
                .isEnabledForClientId(container.getClientId(), FeatureName.ALONE_TRAFARET_OPTION_ENABLED);
        return new ListValidationBuilder<>(vr)
                .checkEachBy(campaign -> new CampaignWithOptionalAloneTrafaretValidator(isAloneTrafaretOptionEnabled)
                        .apply(campaign))
                .getResult();
    }
}
