package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalMeaningfulGoalsValuesFromMetrika;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.forEachModelChangesAddDefectIfFieldChanged;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaForbiddenUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaForbidden> {

    @Override
    public Class<CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaForbidden> getTypeClass() {
        return CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaForbidden.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaForbidden>>,
            Defect> preValidate(CampaignValidationContainer container,
                                ValidationResult<List<ModelChanges<CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaForbidden>>, Defect> vr) {

        forEachModelChangesAddDefectIfFieldChanged(vr,
                CampaignWithOptionalMeaningfulGoalsValuesFromMetrika.IS_MEANINGFUL_GOALS_VALUES_FROM_METRIKA_ENABLED);
        return vr;
    }
}
