package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalMeaningfulGoalsValuesFromMetrika;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.forEachModelChangesAddDefectIfFieldChanged;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithOptionalMeaningfulGoalsValuesFromMetrika> {

    private final FeatureService featureService;

    @Autowired
    public CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaUpdateValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithOptionalMeaningfulGoalsValuesFromMetrika> getTypeClass() {
        return CampaignWithOptionalMeaningfulGoalsValuesFromMetrika.class;
    }


    @Override
    public ValidationResult<List<ModelChanges<CampaignWithOptionalMeaningfulGoalsValuesFromMetrika>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithOptionalMeaningfulGoalsValuesFromMetrika>>, Defect> vr) {
        boolean featureIsEnabled = featureService
                .isEnabledForClientId(container.getClientId(),
                        FeatureName.AUTO_BUDGET_MEANINGFUL_GOALS_VALUES_FROM_METRIKA);

        if (!featureIsEnabled) {
            forEachModelChangesAddDefectIfFieldChanged(vr,
                    CampaignWithOptionalMeaningfulGoalsValuesFromMetrika.IS_MEANINGFUL_GOALS_VALUES_FROM_METRIKA_ENABLED);
        }
        return vr;
    }

    @Override
    public ValidationResult<List<CampaignWithOptionalMeaningfulGoalsValuesFromMetrika>, Defect> validate(CampaignValidationContainer container, ValidationResult<List<CampaignWithOptionalMeaningfulGoalsValuesFromMetrika>, Defect> vr, Map<Integer, AppliedChanges<CampaignWithOptionalMeaningfulGoalsValuesFromMetrika>> appliedChangesForValidModelChanges) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(new CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaValidator())
                .getResult();
    }
}
