package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalS2sTrackingForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithOptionalS2sTrackingForbiddenValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOptionalS2sTrackingForbiddenUpdateValidationTypeSupport extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithOptionalS2sTrackingForbidden> {

    private final CampaignWithOptionalS2sTrackingForbiddenValidator validator =
            new CampaignWithOptionalS2sTrackingForbiddenValidator();

    @Override
    public Class<CampaignWithOptionalS2sTrackingForbidden> getTypeClass() {
        return CampaignWithOptionalS2sTrackingForbidden.class;
    }

    @Override
    public ValidationResult<List<CampaignWithOptionalS2sTrackingForbidden>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithOptionalS2sTrackingForbidden>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }
}
