package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalTitleSubstitution;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithOptionalTitleSubstitutionValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOptionalTitleSubstitutionUpdateValidationTypeSupport extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithOptionalTitleSubstitution> {
    @Override
    public Class<CampaignWithOptionalTitleSubstitution> getTypeClass() {
        return CampaignWithOptionalTitleSubstitution.class;
    }

    @Override
    public ValidationResult<List<CampaignWithOptionalTitleSubstitution>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithOptionalTitleSubstitution>, Defect> vr) {
        var vb = new ListValidationBuilder<>(vr);
        vb.checkEachBy(campaign -> new CampaignWithOptionalTitleSubstitutionValidator().apply(campaign));
        return vb.getResult();
    }
}
