package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOrderPhraseLengthPrecedenceForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.forEachModelChangesAddDefectIfFieldChanged;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOrderPhraseLengthPrecedenceForbiddenUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithOrderPhraseLengthPrecedenceForbidden> {

    @Override
    public Class<CampaignWithOrderPhraseLengthPrecedenceForbidden> getTypeClass() {
        return CampaignWithOrderPhraseLengthPrecedenceForbidden.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithOrderPhraseLengthPrecedenceForbidden>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithOrderPhraseLengthPrecedenceForbidden>>, Defect> vr) {
        forEachModelChangesAddDefectIfFieldChanged(vr,
                CampaignWithOrderPhraseLengthPrecedenceForbidden.IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ENABLED);
        return vr;
    }
}
