package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOrderPhraseLengthPrecedence;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithOrderPhraseLengthPrecedenceForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.forEachModelChangesAddDefectIfFieldChanged;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOrderPhraseLengthPrecedenceUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithOrderPhraseLengthPrecedence> {
    private final FeatureService featureService;

    @Autowired
    public CampaignWithOrderPhraseLengthPrecedenceUpdateValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }


    @Override
    public Class<CampaignWithOrderPhraseLengthPrecedence> getTypeClass() {
        return CampaignWithOrderPhraseLengthPrecedence.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithOrderPhraseLengthPrecedence>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithOrderPhraseLengthPrecedence>>, Defect> vr) {
        boolean isOrderPhraseLengthPrecedenceAllowed = featureService.isEnabledForClientId(container.getClientId(),
                FeatureName.IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ALLOWED);
        if (!isOrderPhraseLengthPrecedenceAllowed) {
            forEachModelChangesAddDefectIfFieldChanged(vr,
                    CampaignWithOrderPhraseLengthPrecedenceForbidden.IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ENABLED);
        }
        return vr;
    }
}
