package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOrganizationAndPhone;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.clientphone.repository.ClientPhoneRepository;
import ru.yandex.direct.core.entity.trackingphone.model.ClientPhone;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.utils.FunctionalUtils.filterAndMapToSet;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;
import static ru.yandex.direct.utils.FunctionalUtils.mapAndFilterToSet;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;
import static ru.yandex.direct.validation.constraint.CommonConstraints.validId;
import static ru.yandex.direct.validation.defect.CommonDefects.objectNotFound;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOrganizationAndPhoneUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithOrganizationAndPhone> {

    private final ClientPhoneRepository clientPhoneRepository;

    @Autowired
    public CampaignWithOrganizationAndPhoneUpdateValidationTypeSupport(ClientPhoneRepository clientPhoneRepository) {
        this.clientPhoneRepository = clientPhoneRepository;
    }

    @Override
    public Class<CampaignWithOrganizationAndPhone> getTypeClass() {
        return CampaignWithOrganizationAndPhone.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithOrganizationAndPhone>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithOrganizationAndPhone>>, Defect> vr) {

        Validator<ModelChanges<CampaignWithOrganizationAndPhone>, Defect> validator = changes -> {
            ItemValidationBuilder<ModelChanges<CampaignWithOrganizationAndPhone>, Defect> vb =
                    ItemValidationBuilder.of(changes);

            vb.item(changes.getPropIfChanged(CampaignWithOrganizationAndPhone.DEFAULT_TRACKING_PHONE_ID),
                    CampaignWithOrganizationAndPhone.DEFAULT_TRACKING_PHONE_ID.name())
                    .check(validId(), When.notNull());

            return vb.getResult();
        };

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }

    @Override
    public ValidationResult<List<CampaignWithOrganizationAndPhone>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithOrganizationAndPhone>, Defect> vr,
            Map<Integer, AppliedChanges<CampaignWithOrganizationAndPhone>> appliedChangesForValidModelChanges) {

        Set<Long> allPermalinkIds = mapAndFilterToSet(appliedChangesForValidModelChanges.values(),
                ac -> ac.getNewValue(CampaignWithOrganizationAndPhone.DEFAULT_PERMALINK_ID),
                Objects::nonNull);

        Set<Long> clientPhones = listToSet(clientPhoneRepository.getAllClientPhones(container.getClientId(),
                allPermalinkIds), ClientPhone::getId);

        Set<Long> changedPhoneIds = filterAndMapToSet(appliedChangesForValidModelChanges.values(),
                ac -> ac.changedAndNotDeleted(CampaignWithOrganizationAndPhone.DEFAULT_TRACKING_PHONE_ID),
                ac -> ac.getNewValue(CampaignWithOrganizationAndPhone.DEFAULT_TRACKING_PHONE_ID));

        if (changedPhoneIds.isEmpty()) {
            return vr;
        }

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator(clientPhones, changedPhoneIds))
                .getResult();
    }

    static Validator<CampaignWithOrganizationAndPhone, Defect> validator(Set<Long> clientPhones,
                                                                         Set<Long> changedPhoneIds) {
        return campaign -> {
            ModelItemValidationBuilder<CampaignWithOrganizationAndPhone> vb =
                    ModelItemValidationBuilder.of(campaign);

            vb.item(CampaignWithOrganizationAndPhone.DEFAULT_TRACKING_PHONE_ID)
                    .check(fromPredicate(clientPhones::contains, objectNotFound()),
                            When.valueIs(changedPhoneIds::contains));

            return vb.getResult();
        };
    }

}
