package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithPlacementTypes;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithPlacementTypesValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithPlacementTypesUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithPlacementTypes> {
    @Override
    public Class<CampaignWithPlacementTypes> getTypeClass() {
        return CampaignWithPlacementTypes.class;
    }

    @Override
    public ValidationResult<List<CampaignWithPlacementTypes>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithPlacementTypes>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(new CampaignWithPlacementTypesValidator())
                .getResult();
    }
}
