package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithPricePackage;
import ru.yandex.direct.core.entity.campaign.service.CpmPriceCampaignService;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignWithPricePackagePermissionUtils;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignWithPricePackageValidateBeforeApplyContext;
import ru.yandex.direct.core.entity.campaign.service.validation.PropertyChangeValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.CampaignWithPricePackageValidationUtils;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithPricePackageValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.pricepackage.model.PricePackage;
import ru.yandex.direct.core.entity.pricepackage.repository.PricePackageRepository;
import ru.yandex.direct.core.entity.pricepackage.service.PricePackageService;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.core.entity.user.service.UserService;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static java.util.Collections.emptySet;
import static ru.yandex.direct.core.entity.campaign.model.CampaignWithPricePackage.END_DATE;
import static ru.yandex.direct.core.entity.campaign.model.CampaignWithPricePackage.FLIGHT_ORDER_VOLUME;
import static ru.yandex.direct.core.entity.campaign.model.CampaignWithPricePackage.FLIGHT_STATUS_APPROVE;
import static ru.yandex.direct.core.entity.campaign.model.CampaignWithPricePackage.START_DATE;
import static ru.yandex.direct.core.entity.campaign.model.CampaignWithPricePackage.STATUS_SHOW;
import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.forEachModelChangesAddDefectIfFieldChanged;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithPricePackageUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithPricePackage> {

    private static final PropertyChangeValidator
            <CampaignWithPricePackage, CampaignWithPricePackageValidateBeforeApplyContext>
            PROPERTY_CHANGE_VALIDATOR = PropertyChangeValidator
            .<CampaignWithPricePackage, CampaignWithPricePackageValidateBeforeApplyContext>newBuilder()
            .add(START_DATE, CampaignWithPricePackagePermissionUtils::canChangeStartDate)
            .add(END_DATE, CampaignWithPricePackagePermissionUtils::canChangeEndDate)
            .add(FLIGHT_ORDER_VOLUME, CampaignWithPricePackagePermissionUtils::canChangeFlightOrderVolume)
            .add(FLIGHT_STATUS_APPROVE, CampaignWithPricePackagePermissionUtils::canChangeFlightStatusApprove)
            .add(STATUS_SHOW, CampaignWithPricePackagePermissionUtils::canChangeStatusShow)
            .build();

    private final PricePackageRepository pricePackageRepository;
    private final PricePackageService pricePackageService;
    private final FeatureService featureService;
    private final UserService userService;
    private final CpmPriceCampaignService cpmPriceCampaignService;

    @Autowired
    public CampaignWithPricePackageUpdateValidationTypeSupport(PricePackageRepository pricePackageRepository,
                                                               PricePackageService pricePackageService,
                                                               FeatureService featureService,
                                                               UserService userService,
                                                               CpmPriceCampaignService cpmPriceCampaignService) {
        this.pricePackageRepository = pricePackageRepository;
        this.pricePackageService = pricePackageService;
        this.featureService = featureService;
        this.userService = userService;
        this.cpmPriceCampaignService = cpmPriceCampaignService;
    }

    @Override
    public Class<CampaignWithPricePackage> getTypeClass() {
        return CampaignWithPricePackage.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithPricePackage>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithPricePackage>>, Defect> vr) {
        forEachModelChangesAddDefectIfFieldChanged(vr, CampaignWithPricePackage.STRATEGY);
        forEachModelChangesAddDefectIfFieldChanged(vr, CampaignWithPricePackage.PRICE_PACKAGE_ID);
        forEachModelChangesAddDefectIfFieldChanged(vr, CampaignWithPricePackage.FLIGHT_TARGETINGS_SNAPSHOT);
        forEachModelChangesAddDefectIfFieldChanged(vr, CampaignWithPricePackage.FLIGHT_STATUS_CORRECT);
        forEachModelChangesAddDefectIfFieldChanged(vr, CampaignWithPricePackage.FLIGHT_REASON_INCORRECT);
        forEachModelChangesAddDefectIfFieldChanged(vr, CampaignWithPricePackage.IS_DRAFT_APPROVE_ALLOWED);
        return vr;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithPricePackage>>, Defect> validateBeforeApply(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithPricePackage>>, Defect> vr,
            Map<Long, CampaignWithPricePackage> unmodifiedModels) {
        User operator = userService.getUser(container.getOperatorUid());
        var pricePackageIds = CampaignWithPricePackageValidationUtils.extractPricePackageIds(unmodifiedModels.values());
        Map<Long, PricePackage> pricePackagesMap = pricePackageService.getPricePackages(pricePackageIds);

        Set<String> features = operator == null ? emptySet() :
                featureService.getEnabledForClientId(operator.getClientId());

        List<CampaignWithPricePackage> campaignsWaitingApprove = cpmPriceCampaignService
                .filterCpmPriceCampaignsEligibleForApprove(container.getShard(), unmodifiedModels.values());

        var context = new CampaignWithPricePackageValidateBeforeApplyContext(operator, pricePackagesMap,
                features, campaignsWaitingApprove);

        return new ListValidationBuilder<>(vr)
                .checkEachBy((index, modelChanges) -> {
                    CampaignWithPricePackage model = unmodifiedModels.get(modelChanges.getId());
                    return PROPERTY_CHANGE_VALIDATOR.validate(modelChanges, model, context);
                })
                .getResult();
    }

    @Override
    public ValidationResult<List<CampaignWithPricePackage>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithPricePackage>, Defect> vr) {
        var pricePackageIds = CampaignWithPricePackageValidationUtils.extractPricePackageIds(vr.getValue());
        var pricePackages = pricePackageRepository.getPricePackages(pricePackageIds);
        var availableFeatures = featureService.getEnabledForClientId(container.getClientId());
        var commonValidator = new CampaignWithPricePackageValidator(pricePackages, availableFeatures);
        return new ListValidationBuilder<>(vr)
                .checkEachBy(commonValidator)
                .getResult();
    }
}
