package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignMetatype;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithRecommendationsManagement;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static java.lang.Boolean.FALSE;
import static java.lang.Boolean.TRUE;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithRecommendationsManagementUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithRecommendationsManagement> {
    @SuppressWarnings("java:S3252")
    private static final ModelProperty<? super CampaignWithRecommendationsManagement, Boolean>
            PRICE_REC_PROP = CampaignWithRecommendationsManagement.IS_PRICE_RECOMMENDATIONS_MANAGEMENT_ENABLED;

    @SuppressWarnings("java:S3252")
    private static final ModelProperty<? super CampaignWithRecommendationsManagement, Boolean>
            REC_PROP = CampaignWithRecommendationsManagement.IS_RECOMMENDATIONS_MANAGEMENT_ENABLED;

    @Override
    @SuppressWarnings("rawtypes")
    public ValidationResult<List<ModelChanges<CampaignWithRecommendationsManagement>>, Defect> validateBeforeApply(
            CampaignValidationContainer ignored,
            ValidationResult<List<ModelChanges<CampaignWithRecommendationsManagement>>, Defect> vr,
            Map<Long, CampaignWithRecommendationsManagement> unmodifiedModels
    ) {
        var vb = new ListValidationBuilder<>(vr);
        // проверяем, что не получается PRICE_REC_PROP = true и REC_PROP = false
        vb.checkEachBy(mc -> {
            ItemValidationBuilder<ModelChanges<CampaignWithRecommendationsManagement>, Defect> ivb =
                    ItemValidationBuilder.of(mc);
            var campaign = unmodifiedModels.get(mc.getId());
            if (campaign == null) {
                return ivb.getResult();
            }

            // Итоговое значение флага isPriceRecommendationsManagementEnabled
            var resultingPriceRecProp = (
                    mc.isPropChanged(PRICE_REC_PROP) && TRUE.equals(mc.getChangedProp(PRICE_REC_PROP)))
                    || (!mc.isPropChanged(PRICE_REC_PROP)
                    && TRUE.equals(campaign.getIsPriceRecommendationsManagementEnabled()));

            ivb.item(mc.getPropIfChanged(REC_PROP), REC_PROP.name())
                    .check(
                            Constraint.fromPredicate(
                                    rm -> !TRUE.equals(rm)
                                            || campaign.getMetatype() != CampaignMetatype.ECOM,
                                    CommonDefects.inconsistentState()
                            )
                    )
                    .check(
                            Constraint.fromPredicate(
                                    rm -> !FALSE.equals(rm) || !resultingPriceRecProp,
                                    CommonDefects.inconsistentState()
                            ),
                            When.isValid()
                    );

            // Итоговое значение флага isRecommendationsManagementEnabled
            var resultingRecProp = (mc.isPropChanged(REC_PROP) && TRUE.equals(mc.getChangedProp(REC_PROP)))
                    || (!mc.isPropChanged(REC_PROP) && TRUE.equals(campaign.getIsRecommendationsManagementEnabled()));

            ivb.item(mc.getPropIfChanged(PRICE_REC_PROP), PRICE_REC_PROP.name())
                    .check(
                            Constraint.fromPredicate(
                                    prm -> !TRUE.equals(prm) || resultingRecProp,
                                    CommonDefects.inconsistentState()
                            ),
                            When.isTrue(!ivb.getResult().hasAnyErrors()) // неконсистентность отмечена на другом поле
                    );

            return ivb.getResult();
        });
        return vb.getResult();
    }

    @Override
    public Class<CampaignWithRecommendationsManagement> getTypeClass() {
        return CampaignWithRecommendationsManagement.class;
    }
}
