package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithRequireFiltrationByDontShowDomainsForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithRequireFiltrationByDontShowDomainsForbiddenValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithRequireFiltrationByDontShowDomainsForbiddenUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithRequireFiltrationByDontShowDomainsForbidden> {

    @Override
    public Class<CampaignWithRequireFiltrationByDontShowDomainsForbidden> getTypeClass() {
        return CampaignWithRequireFiltrationByDontShowDomainsForbidden.class;
    }

    @Override
    public ValidationResult<List<CampaignWithRequireFiltrationByDontShowDomainsForbidden>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithRequireFiltrationByDontShowDomainsForbidden>, Defect> vr) {

        var validator = new CampaignWithRequireFiltrationByDontShowDomainsForbiddenValidator();

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }
}
