package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithSimplifiedStrategyViewForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.forEachModelChangesAddDefectIfFieldChanged;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithSimplifiedStrategyViewForbiddenUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithSimplifiedStrategyViewForbidden> {
    @Override
    public Class<CampaignWithSimplifiedStrategyViewForbidden> getTypeClass() {
        return CampaignWithSimplifiedStrategyViewForbidden.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithSimplifiedStrategyViewForbidden>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithSimplifiedStrategyViewForbidden>>, Defect> vr) {
        forEachModelChangesAddDefectIfFieldChanged(vr,
                CampaignWithSimplifiedStrategyViewForbidden.IS_SIMPLIFIED_STRATEGY_VIEW_ENABLED);
        return vr;
    }
}
