package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithSkadNetworkForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.forEachModelChangesAddDefectIfFieldChanged;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithSkadNetworkForbiddenUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithSkadNetworkForbidden> {

    @Override
    public Class<CampaignWithSkadNetworkForbidden> getTypeClass() {
        return CampaignWithSkadNetworkForbidden.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithSkadNetworkForbidden>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithSkadNetworkForbidden>>, Defect> vr
    ) {
        forEachModelChangesAddDefectIfFieldChanged(vr, CampaignWithSkadNetworkForbidden.IS_SKAD_NETWORK_ENABLED);
        return vr;
    }
}
