package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithSkadNetwork;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.forEachModelChangesAddDefectIfFieldChanged;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithSkadNetworkUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithSkadNetwork> {

    private final FeatureService featureService;

    public CampaignWithSkadNetworkUpdateValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithSkadNetwork> getTypeClass() {
        return CampaignWithSkadNetwork.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithSkadNetwork>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithSkadNetwork>>, Defect> vr
    ) {
        var isShowRmpOnNewIosVersionEnabled = featureService.isEnabledForClientId(
                container.getClientId(), FeatureName.SHOW_SKADNETWORK_ON_NEW_IOS_ENABLED
        );

        if (!isShowRmpOnNewIosVersionEnabled) {
            forEachModelChangesAddDefectIfFieldChanged(vr, CampaignWithSkadNetwork.IS_SKAD_NETWORK_ENABLED);
        }

        return vr;
    }
}
