package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithTitleSubstitutionForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.forEachModelChangesAddDefectIfFieldChanged;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithTitleSubstitutionForbiddenUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithTitleSubstitutionForbidden> {

    @Autowired
    public CampaignWithTitleSubstitutionForbiddenUpdateValidationTypeSupport() {
    }

    @Override
    public Class<CampaignWithTitleSubstitutionForbidden> getTypeClass() {
        return CampaignWithTitleSubstitutionForbidden.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithTitleSubstitutionForbidden>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithTitleSubstitutionForbidden>>, Defect> vr) {
        forEachModelChangesAddDefectIfFieldChanged(vr, CampaignWithTitleSubstitutionForbidden.HAS_TITLE_SUBSTITUTION);
        return vr;
    }

}
