package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithTurboApp;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithTurboAppValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithTurboAppUpdateValidationTypeSupport extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithTurboApp> {

    private final FeatureService featureService;

    @Autowired
    public CampaignWithTurboAppUpdateValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithTurboApp> getTypeClass() {
        return CampaignWithTurboApp.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithTurboApp>>, Defect> validateBeforeApply(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithTurboApp>>, Defect> vr,
            Map<Long, CampaignWithTurboApp> unmodifiedModels) {

        boolean canEnableTurboApps = featureService.isEnabledForClientId(container.getClientId(), FeatureName.TURBO_APP_ALLOWED);

        var validator = new CampaignWithTurboAppValidator(canEnableTurboApps);

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator::applyForModelChanges)
                .getResult();
    }

}
