package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CpmCampaignWithCustomStrategy;
import ru.yandex.direct.core.entity.campaign.model.DbStrategyBase;
import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.core.entity.campaign.service.CampaignStrategyService;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignWithStrategyValidationUtils;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.strategy.CpmCampaignWithCustomStrategyBeforeApplyValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.client.model.Client;
import ru.yandex.direct.core.entity.client.service.ClientService;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static java.time.LocalDate.now;

@Component
@ParametersAreNonnullByDefault
public class CpmCampaignWithCustomStrategyUpdateValidationTypeSupport extends AbstractCampaignUpdateValidationTypeSupport<CpmCampaignWithCustomStrategy> {
    private final CampaignStrategyService campaignStrategyService;
    private final ClientService clientService;

    @Override
    public Class<CpmCampaignWithCustomStrategy> getTypeClass() {
        return CpmCampaignWithCustomStrategy.class;
    }

    @Autowired
    public CpmCampaignWithCustomStrategyUpdateValidationTypeSupport(CampaignStrategyService campaignStrategyService,
                                                                    ClientService clientService) {
        this.campaignStrategyService = campaignStrategyService;
        this.clientService = clientService;
    }

    @Override
    public ValidationResult<List<ModelChanges<CpmCampaignWithCustomStrategy>>, Defect> validateBeforeApply(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CpmCampaignWithCustomStrategy>>, Defect> vr,
            Map<Long, CpmCampaignWithCustomStrategy> unmodifiedModels) {
        Client client = clientService.getClient(container.getClientId());

        ListValidationBuilder<ModelChanges<CpmCampaignWithCustomStrategy>, Defect> vb = new ListValidationBuilder<>(vr);


        List<ModelChanges<CpmCampaignWithCustomStrategy>> modelChanges = vr.getValue();
        Map<Long, LocalDate> finishDatesById = StreamEx.of(modelChanges)
                .mapToEntry(ModelChanges::getId, mc -> mc.getPropIfChanged(CpmCampaignWithCustomStrategy.STRATEGY))
                .nonNullValues()
                .mapValues(DbStrategyBase::getStrategyData)
                .mapValues(StrategyData::getFinish)
                .nonNullValues()
                .toMap();

        List<CpmCampaignWithCustomStrategy> actualCampaignWithCustomStrategiesOnRestart =
                StreamEx.of(unmodifiedModels.values())
                        .mapToEntry(c -> c.getStrategy().getStrategyData())
                        .filterValues(CampaignWithStrategyValidationUtils::isStrategyNameForCpmStrategyWithCustomPeriod)
                        .keys()
                        .filter(c -> finishDatesById.containsKey(c.getId()))
                        .toList();

        List<LocalDate> finishDataListForStrategiesWithoutRestart = StreamEx.of(actualCampaignWithCustomStrategiesOnRestart)
                .map(CpmCampaignWithCustomStrategy::getId)
                .map(finishDatesById::get)
                .toList();
        Map<Long, BigDecimal> minimalBudgetByCampaignId =
                campaignStrategyService.calculateMinimalAvailableBudgetForCpmNotRestartingStrategyWithCustomPeriod(
                        actualCampaignWithCustomStrategiesOnRestart,
                        finishDataListForStrategiesWithoutRestart,
                        client.getWorkCurrency());

        LocalDate now = now();
        vb.checkEachBy(mc -> CpmCampaignWithCustomStrategyBeforeApplyValidator.build(
                minimalBudgetByCampaignId.get(mc.getId()),
                client.getWorkCurrency(),
                unmodifiedModels.get(mc.getId()),
                now

        ).apply(mc));
        return vb.getResult();
    }

}
