package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.InternalCampaign;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.InternalCampaignCommonValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignValidators.fieldCantBeModified;
import static ru.yandex.direct.core.validation.defects.RightsDefects.forbiddenToChange;

@Component
@ParametersAreNonnullByDefault
public class InternalCampaignUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<InternalCampaign> {

    private static final InternalCampaignCommonValidator VALIDATOR = new InternalCampaignCommonValidator();

    @Override
    public Class<InternalCampaign> getTypeClass() {
        return InternalCampaign.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<InternalCampaign>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<InternalCampaign>>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(fieldCantBeModified(InternalCampaign.PLACE_ID, forbiddenToChange()))
                .checkEachBy(fieldCantBeModified(InternalCampaign.IS_MOBILE, forbiddenToChange()))
                .getResult();
    }

    @Override
    public ValidationResult<List<InternalCampaign>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<InternalCampaign>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(VALIDATOR)
                .getResult();
    }

}
