package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.Collections;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.InternalBanner;
import ru.yandex.direct.core.entity.banner.repository.BannerTypedRepository;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithImpressionRate;
import ru.yandex.direct.core.entity.campaign.model.InternalCampaignWithImpressionRate;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.InternalCampaignWithImpressionRateValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.internalads.Constants;
import ru.yandex.direct.core.entity.internalads.model.InternalTemplateInfo;
import ru.yandex.direct.core.entity.internalads.service.TemplateInfoService;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static java.util.function.Function.identity;
import static ru.yandex.direct.core.entity.internalads.InternalAdValidationUtil.getBannerWithCloseCounterVarIds;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

@Component
@ParametersAreNonnullByDefault
public class InternalCampaignWithImpressionRateUpdateValidationTypeSupport extends
        AbstractCampaignUpdateValidationTypeSupport<InternalCampaignWithImpressionRate> {

    private final BannerTypedRepository bannerTypedRepository;
    private final TemplateInfoService templateInfoService;

    @Autowired
    public InternalCampaignWithImpressionRateUpdateValidationTypeSupport(BannerTypedRepository bannerTypedRepository,
                                                                         TemplateInfoService templateInfoService) {
        this.bannerTypedRepository = bannerTypedRepository;
        this.templateInfoService = templateInfoService;
    }

    @Override
    public Class<InternalCampaignWithImpressionRate> getTypeClass() {
        return InternalCampaignWithImpressionRate.class;
    }

    @Override
    public ValidationResult<List<InternalCampaignWithImpressionRate>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<InternalCampaignWithImpressionRate>, Defect> vr) {
        var campaignIds = listToSet(vr.getValue(), CampaignWithImpressionRate::getId);
        var banners = bannerTypedRepository.getBannersByCampaignIdsAndClass(container.getShard(), campaignIds,
                InternalBanner.class);
        var bannersByCampaignId = StreamEx.of(banners)
                .mapToEntry(InternalBanner::getCampaignId, identity())
                .grouping();

        var templateIds = listToSet(banners, InternalBanner::getTemplateId);
        List<InternalTemplateInfo> templateInfoList = templateInfoService.getByTemplateIds(templateIds);

        var bannerWithCloseCounterVarIdsByCampaignId = StreamEx.of(campaignIds)
                .mapToEntry(campaignId -> bannersByCampaignId.getOrDefault(campaignId, Collections.emptyList()))
                .mapValues(campaignsBanners -> getBannerWithCloseCounterVarIds(campaignsBanners, templateInfoList,
                        Constants.CLOSE_BY_CAMPAIGN_COUNTER_VALUE))
                .toMap();

        return new ListValidationBuilder<>(vr)
                .checkEachBy(campaign -> new InternalCampaignWithImpressionRateValidator(
                        campaign.getRfCloseByClick(),
                        bannerWithCloseCounterVarIdsByCampaignId.get(campaign.getId()))
                        .apply(campaign)
                )
                .getResult();
    }

}
