package ru.yandex.direct.core.entity.campcalltrackingphones.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.calltracking.model.CampCalltrackingPhones;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static ru.yandex.direct.dbschema.ppc.tables.CampCalltrackingPhones.CAMP_CALLTRACKING_PHONES;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Repository
@ParametersAreNonnullByDefault
public class CampCalltrackingPhonesRepository {
    private final DslContextProvider dslContextProvider;

    private final JooqMapperWithSupplier<CampCalltrackingPhones> mapper = createMapper();

    public CampCalltrackingPhonesRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    private JooqMapperWithSupplier<CampCalltrackingPhones> createMapper() {
        return JooqMapperWithSupplierBuilder.builder(CampCalltrackingPhones::new)
                .map(property(CampCalltrackingPhones.CLIENT_PHONE_ID, CAMP_CALLTRACKING_PHONES.CLIENT_PHONE_ID))
                .map(property(CampCalltrackingPhones.CID, CAMP_CALLTRACKING_PHONES.CID))
                .build();
    }

    public void add(int shard, long clientPhoneId, long campaignId) {
        CampCalltrackingPhones model = new CampCalltrackingPhones()
                .withClientPhoneId(clientPhoneId)
                .withCid(campaignId);
        new InsertHelper<>(dslContextProvider.ppc(shard), CAMP_CALLTRACKING_PHONES)
                .add(mapper, model)
                .execute();
    }

    /**
     * Удаляет все записи с переданными clientPhoneId и добавляет в таблицу новый набор записей
     */
    public void updateCampCalltrackingPhonesList(int shard, Collection<Long> clientPhoneIds,
                                                 List<CampCalltrackingPhones> campCalltrackingPhones) {
        delete(shard, clientPhoneIds);

        if (campCalltrackingPhones.isEmpty()) {
            return;
        }

        new InsertHelper<>(dslContextProvider.ppc(shard), CAMP_CALLTRACKING_PHONES)
                .addAll(mapper, campCalltrackingPhones)
                .executeIfRecordsAdded();
    }

    public void delete(int shard, Collection<Long> clientPhoneIds) {
        dslContextProvider.ppc(shard)
                .delete(CAMP_CALLTRACKING_PHONES)
                .where(CAMP_CALLTRACKING_PHONES.CLIENT_PHONE_ID.in(clientPhoneIds))
                .execute();
    }

    public Map<Long, List<CampCalltrackingPhones>> getByCampaignId(int shard) {
        return dslContextProvider.ppc(shard)
                .select(mapper.getFieldsToRead())
                .from(CAMP_CALLTRACKING_PHONES)
                .orderBy(CAMP_CALLTRACKING_PHONES.CLIENT_PHONE_ID, CAMP_CALLTRACKING_PHONES.CID)
                .fetchGroups(CAMP_CALLTRACKING_PHONES.CID, mapper::fromDb);
    }
}
