package ru.yandex.direct.core.entity.campcalltrackingphones.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.calltracking.model.CampCalltrackingPhones;
import ru.yandex.direct.core.entity.campcalltrackingphones.repository.CampCalltrackingPhonesRepository;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Service
public class CampCalltrackingPhonesService {
    private final CampCalltrackingPhonesRepository campCalltrackingPhonesRepository;

    public CampCalltrackingPhonesService(CampCalltrackingPhonesRepository campCalltrackingPhonesRepository) {
        this.campCalltrackingPhonesRepository = campCalltrackingPhonesRepository;
    }

    public Map<Long, List<Long>> getClientPhoneIdsByCampaignId(int shard) {
        Map<Long, List<CampCalltrackingPhones>> modelsByCampaignId =
                campCalltrackingPhonesRepository.getByCampaignId(shard);
        return modelsByCampaignId.entrySet()
                .stream()
                .collect(Collectors.toMap(
                        Map.Entry::getKey,
                        e -> mapList(e.getValue(), CampCalltrackingPhones::getClientPhoneId)
                ));
    }

    public void updateCampCalltrackingPhonesList(int shard, Collection<Long> clientPhoneIds, List<CampCalltrackingPhones> campCalltrackingPhones) {
        campCalltrackingPhonesRepository.updateCampCalltrackingPhonesList(shard, clientPhoneIds, campCalltrackingPhones);
    }
}
