package ru.yandex.direct.core.entity.campcalltrackingsettings.repository;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.util.mysql.MySQLDSL;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.calltracking.model.CampCalltrackingSettings;
import ru.yandex.direct.dbschema.ppc.tables.records.CampCalltrackingSettingsRecord;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static ru.yandex.direct.dbschema.ppc.tables.CampCalltrackingSettings.CAMP_CALLTRACKING_SETTINGS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Repository
@ParametersAreNonnullByDefault
public class CampCalltrackingSettingsRepository {
    private final DslContextProvider dslContextProvider;
    private final ShardHelper shardHelper;

    private final JooqMapperWithSupplier<CampCalltrackingSettings> mapper = createMapper();

    public CampCalltrackingSettingsRepository(DslContextProvider dslContextProvider, ShardHelper shardHelper) {
        this.dslContextProvider = dslContextProvider;
        this.shardHelper = shardHelper;
    }

    private JooqMapperWithSupplier<CampCalltrackingSettings> createMapper() {
        return JooqMapperWithSupplierBuilder.builder(CampCalltrackingSettings::new)
                .map(property(CampCalltrackingSettings.CID, CAMP_CALLTRACKING_SETTINGS.CID))
                .map(property(CampCalltrackingSettings.CALLTRACKING_SETTINGS_ID,
                        CAMP_CALLTRACKING_SETTINGS.CALLTRACKING_SETTINGS_ID))
                .build();
    }

    public void addOrUpdate(ClientId clientId, List<CampCalltrackingSettings> campCalltrackingSettings) {
        int shard = shardHelper.getShardByClientId(clientId);

        if (campCalltrackingSettings.isEmpty()) {
            return;
        }

        InsertHelper<CampCalltrackingSettingsRecord> insertHelper =
                new InsertHelper<>(dslContextProvider.ppc(shard), CAMP_CALLTRACKING_SETTINGS)
                        .addAll(mapper, campCalltrackingSettings);

        if (insertHelper.hasAddedRecords()) {
            insertHelper
                    .onDuplicateKeyUpdate()
                    .set(CAMP_CALLTRACKING_SETTINGS.CALLTRACKING_SETTINGS_ID,
                            MySQLDSL.values(CAMP_CALLTRACKING_SETTINGS.CALLTRACKING_SETTINGS_ID));
        }

        insertHelper.executeIfRecordsAdded();
    }

    public Set<Long> getCampaignIds(int shard, long calltrackingSettingsId) {
        return dslContextProvider.ppc(shard)
                .select(CAMP_CALLTRACKING_SETTINGS.CID)
                .from(CAMP_CALLTRACKING_SETTINGS)
                .where(CAMP_CALLTRACKING_SETTINGS.CALLTRACKING_SETTINGS_ID.eq(calltrackingSettingsId))
                .fetchSet(CAMP_CALLTRACKING_SETTINGS.CID);
    }

    public void delete(ClientId clientId, Long campaignId) {
        int shard = shardHelper.getShardByClientId(clientId);
        dslContextProvider.ppc(shard)
                .delete(CAMP_CALLTRACKING_SETTINGS)
                .where(CAMP_CALLTRACKING_SETTINGS.CID.eq(campaignId))
                .execute();
    }
}
