package ru.yandex.direct.core.entity.cashback;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbutil.model.ClientId;

@ParametersAreNonnullByDefault
public class CashbackConstants {
    /**
     * Идентификатор технической программы.
     * <p>
     * Техническая программа используется для хранения состояния включенности кешбэков в общем для пользователя
     * (пользователь может выйти из программы лояльности и отказать от всех кешбэков).
     *
     * @see <a href="https://wiki.yandex-team.ru/users/kozobrodov/cashbacks/">Документация</a>
     */
    public static final Long TECHNICAL_PROGRAM_ID = 1L;
    /**
     * Идентификатор ручной программы. Id 14 выбран как первый свободный на тот момент на всех базах (devtest, ts, prod).
     * <p>
     * Иногда что-то не сходится и менеджерам нужна возможность добавить кешбэки самостоятельно
     * Кешбэки добавляются при помощи формы
     *
     * @see <a href="https://wiki.yandex-team.ru/users/jaffry/projects/cashback/">Форма для ручных кешбэков</a>
     */
    public static final Long MANUAL_PROGRAM_ID = 14L;

    /**
     * Идентификатор технической категории, в которой создана техническая программа.
     */
    public static final Long TECHNICAL_PROGRAM_CATEGORY_ID = 1L;
    /**
     * Идентификатор ручной категории, в которой создана ручная программа.
     */
    public static final Long MANUAL_PROGRAM_CATEGORY_ID = 14L;

    /**
     * Идентификатор технического клиента, используется для хранения истории и состояний публичных программ
     */
    public static final ClientId PUBLIC_PROGRAMS_CLIENT_ID = ClientId.fromLong(0L);
    public static final int PUBLIC_PROGRAMS_SHARD_ID = 1;

    /**
     * Минимальный период в месяцах, по которому можно запросить детализацию начисления кешбэков
     */
    public static final int DETALIZATION_MIN_LENGTH = 1;

    /**
     * Максимальный период в месяцах, по которому можно запросить детализацию начисления кешбэков
     */
    public static final int DETALIZATION_MAX_LENGTH = 120;

    private CashbackConstants() { }
}
