package ru.yandex.direct.core.entity.cashback.model;

import java.math.BigDecimal;

public class CashbackCardProgramInternal {
    private final Long programId;
    private final String name;
    private final BigDecimal percent;
    private final String tooltipInfo;
    private final String tooltipLink;
    private final String tooltipLinkText;
    private final Long order;
    private final boolean isTechnical;

    private final boolean isGeneral;
    private final boolean isNew;

    public CashbackCardProgramInternal(CashbackCardsProgram dbProgram, Long order, String language) {
        this.programId = dbProgram.getId();
        this.percent = dbProgram.getPercent();
        this.tooltipLink = dbProgram.getTooltipLink();
        this.order = order;
        this.isGeneral = dbProgram.getIsGeneral();
        this.isNew = dbProgram.getIsNew();
        this.isTechnical = dbProgram.getIsTechnical();
        switch (language) {
            case "RU":
                this.name = dbProgram.getNameRu();
                this.tooltipInfo = dbProgram.getTooltipInfoRu();
                this.tooltipLinkText = dbProgram.getTooltipLinkTextRu();
                break;
            case "EN":
                this.name = dbProgram.getNameEn();
                this.tooltipInfo = dbProgram.getTooltipInfoEn();
                this.tooltipLinkText = dbProgram.getTooltipLinkTextEn();
                break;
            default:
                throw new IllegalArgumentException(String.format("Unsupported language %s", language));
        }
    }

    public Long getProgramId() {
        return programId;
    }

    public String getName() {
        return name;
    }

    public BigDecimal getPercent() {
        return percent;
    }

    public String getTooltipInfo() {
        return tooltipInfo;
    }

    public String getTooltipLink() {
        return tooltipLink;
    }

    public String getTooltipLinkText() {
        return tooltipLinkText;
    }

    public Long getOrder() {
        return order;
    }

    public boolean isGeneral() {
        return isGeneral;
    }

    public boolean isNew() {
        return isNew;
    }

    public boolean isTechnical() {
        return isTechnical;
    }
}
