package ru.yandex.direct.core.entity.cashback.model;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import one.util.streamex.StreamEx;

public class CashbackRewardDetails {

    @JsonProperty("details")
    private List<CashbackRewardDetailsRow> details;

    public List<CashbackRewardDetailsRow> getDetails() {
        return details;
    }

    public CashbackRewardDetails withDetails(List<CashbackRewardDetailsRow> details) {
        this.details = details;
        return this;
    }

    public void addRewardDetails(CashbackRewardDetails anotherDetails) {
        for (CashbackRewardDetailsRow anotherRow : anotherDetails.getDetails()) {
            var programId = anotherRow.getProgramId();
            var thisRow = StreamEx.of(details).findFirst(row -> row.getProgramId().equals(programId));
            if (thisRow.isPresent()) {
                thisRow.get().addRewardDetailsRow(anotherRow);
            } else {
                details.add(anotherRow);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CashbackRewardDetails that = (CashbackRewardDetails) o;
        return details.equals(that.details);
    }

    @Override
    public int hashCode() {
        return Objects.hash(details);
    }
}
