package ru.yandex.direct.core.entity.cashback.model;

import java.math.BigDecimal;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

public class CashbackRewardDetailsRow {
    @JsonProperty("program_id")
    private Long programId;

    @JsonProperty("reward")
    private BigDecimal reward;

    @JsonProperty("reward_wo_nds")
    private BigDecimal rewardWithoutNds;

    public void addRewardDetailsRow(CashbackRewardDetailsRow anotherRow) {
        if (!this.programId.equals(anotherRow.getProgramId())) {
            throw new IllegalArgumentException(String.format("this program id %d != another program id %d",
                    this.programId, anotherRow.getProgramId()));
        }
        this.reward = this.reward.add(anotherRow.getReward());
        this.rewardWithoutNds = this.rewardWithoutNds.add(anotherRow.getRewardWithoutNds());
    }

    public Long getProgramId() {
        return programId;
    }

    public CashbackRewardDetailsRow withProgramId(Long programId) {
        this.programId = programId;
        return this;
    }

    public BigDecimal getReward() {
        return reward;
    }

    public CashbackRewardDetailsRow withReward(BigDecimal reward) {
        this.reward = reward;
        return this;
    }

    public BigDecimal getRewardWithoutNds() {
        return rewardWithoutNds;
    }

    public CashbackRewardDetailsRow withRewardWithoutNds(BigDecimal rewardWithoutNds) {
        this.rewardWithoutNds = rewardWithoutNds;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CashbackRewardDetailsRow that = (CashbackRewardDetailsRow) o;
        return programId.equals(that.programId) && reward.equals(that.reward) && rewardWithoutNds.equals(that.rewardWithoutNds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(programId, reward, rewardWithoutNds);
    }
}
